<?php
header('Content-Type: application/json; charset=utf-8');

// Configuration
$token_secret = 'JACO2025';
$expected_token = isset($_GET['token']) ? $_GET['token'] : '';

if ($expected_token !== $token_secret) {
    echo json_encode(['error' => 'Access denied']);
    exit;
}

// Lire le fichier nowplaying.txt
$file = __DIR__ . '/nowplaying.txt';
if (!file_exists($file)) {
    echo json_encode(['error' => 'nowplaying.txt not found']);
    exit;
}

$content = trim(file_get_contents($file));
list($artist, $title) = array_map('trim', explode(' - ', $content, 2));

// Nettoyage du nom du fichier
function sanitize($string) {
    $string = preg_replace('/[\x00-\x1F\x7F"'\\]/', '', $string); // caractères non imprimables
    $string = str_replace(['/', '\\', ':', '*', '?', '"', '<', '>', '|'], '', $string); // caractères interdits
    return $string;
}

$artist_clean = sanitize($artist);
$title_clean = sanitize($title);
$cover_file = __DIR__ . "/covers/{$artist_clean} - {$title_clean}.jpg";

// 1. Vérifier si une pochette locale existe
if (file_exists($cover_file)) {
    $artwork = "covers/" . rawurlencode("{$artist_clean} - {$title_clean}.jpg");
} else {
    // 2. Requête iTunes API
    $query = urlencode("{$artist} {$title}");
    $itunes_url = "https://itunes.apple.com/search?term={$query}&entity=song&limit=1";

    $response = @file_get_contents($itunes_url);
    $data = @json_decode($response, true);

    if (!empty($data['results'][0]['artworkUrl100'])) {
        $artwork = str_replace('100x100bb.jpg', '600x600bb.jpg', $data['results'][0]['artworkUrl100']);
    } else {
        $artwork = '';
    }
}

// Retour JSON
echo json_encode([
    'artist' => $artist,
    'title' => $title,
    'artwork' => $artwork
], JSON_UNESCAPED_UNICODE);
?>